import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Form, TextArea, Checkbox} from 'react-form';
import Text from "../Fields/Text/Text";
import DateTime from "../Fields/DateTime/DateTime";
import Loading from "../../Loading/Loading";
import {withApollo} from "react-apollo";
import {withRouter} from "react-router-dom";
import Permessions from "../../../permissions";

import gql from "graphql-tag";
import {futch} from "../../../utils";
import DeleteButton from "../../DeleteButton";

class DocumentsFormComponent extends Component {

    selectedFile = null;

    constructor(props) {
        super(props);

        this.state = {
		submitting: false,
            error: false,
		file: null
        };
        this.onSubmit = this.onSubmit.bind(this);
	    this.handleChange = this.handleChange.bind(this);
    }

    handleChange(event) {
        event.preventDefault();
        console.log(event.target.files[0]);
        this.selectedFile = event.target.files[0];
	this.setState({file:this.selectedFile})
    }

    onSubmit(values) {

        const {client, submitMutation, data} = this.props;

        this.setState({submitting: true});

	this.setState({
            uploadDocumentStatus: "Creazione della Risorsa",
            submittingDocument: true,
            uploadDocumentError: false,
        });

	let uuid
	let docid
	let variables = {
            documento: {
                ...values
            }
        };
	delete variables.documento.__typename;
	if (!variables.documento.inElenco) variables.documento.inElenco = 'S'

	client.mutate({
            mutation: gql`
                mutation myUpDoc ($d:DocumentoInput) {
                    updateDocumento(documento: $d) {
                        uuid
			id
                    }
                }
            `,
	    variables: {d: variables.documento}
        }).then(result => {
		uuid = result.data.updateDocumento.uuid;
		docid = result.data.updateDocumento.id;
	    if (this.selectedFile) {
            const body = new FormData();
            body.append("file", this.selectedFile);
            body.append("uuid", uuid);
            return futch("/upload", {method: "POST", body: body}, (progressEvent) => {
                const percent = Math.round((progressEvent.loaded / progressEvent.total) * 100);
                this.setState({uploadDocumentStatus: percent + "% - Upload del file in corso"});
            });
	    }
	    else return 1
        }).then(result => {
            const resultJson = JSON.parse(result);
            if(resultJson.risultato === "error") {
                client.mutate({
                    variables: {
                        id: docid,
                    },
                    mutation: gql`mutation($id: Long) {
                        deleteDocumento(id: $id)
                    }`
                });
                throw new Error(result);
            }
	}).then(res => {
            if(this.props.onSubmitComplete) {
                this.props.onSubmitComplete();
            } else {
                this.props.history.goBack();
            }
        }).catch(err => {
            console.log(err);
            this.setState({
                submitting: false,
                error: true,
            });
        });


    }

    render() {
        const {
            data,
            readOnly
        } = this.props;

        if(data && data.loading) {
            return(<Loading/>);
        }

        return (
            <Form
                defaultValues={data ? data.documento : null}
                onSubmit={this.onSubmit}>
                {(formApi) => <form onSubmit={formApi.submitForm}>
                        <div className="row">
                            <div className="col">
                                <h5>Informazioni Documento</h5>
                            </div>
                        </div>
                        <div className="row">
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="id">ID</label>
                                    <Text
                                        readOnly={true}
                                        field="id"
                                        id="id"
                                        type="text"
                                        className="form-control" />
                                </div>
                            </div>
                        </div>

                        <div className="row">
                            <div className="col-md-8">
                                <div className="form-group">
                                    <label htmlFor="nome">Nome</label>
                                    <Text field="nomeFile"
                                          readOnly={readOnly}
                                          id="nomeFile"
                                          type="text"
                                          className="form-control" />
                                </div>
                            </div>
                        </div>
                        <div className="row">
                            <div className="col-md-8">
                                <div className="form-group">
                                    <label htmlFor="descrizione">Descrizione</label>
                                    <Text field="descrizione"
                                          readOnly={readOnly}
                                          id="descrizione"
                                          type="text"
                                          className="form-control" />
                                </div>
                            </div>
                        </div>

			<div className="row">
			    <label>Documento</label>
                            <input disabled={this.state.submittingDocument} type="file" onChange={this.handleChange} className="form-control-file" />
                            <small className="form-text text-muted">Seleziona il documento da caricare (lascia vuoto per mantenere quello esistente).</small>
			</div>

                        {this.state.error && <div className="row">
                            <div className="col">
                                <div className="text-info text-center">Errore durante il salvataggio del documento</div>
                            </div>
                        </div>}

                        <div className="row">
                            <div className="col">
                                <button disabled={this.state.submitting || (!this.state.file && (!data || !data.documento || !data.documento.id))} type="submit" className="btn btn-primary">
                                    {data && data.documento && data.documento.id ? "Aggiorna documento" : "Crea documento"}
                                </button>
                            </div>
                        </div>
                </form>}
            </Form>);
    }
}

const DocumentsForm = withRouter(withApollo(DocumentsFormComponent));

DocumentsForm.defaultProps = {};

DocumentsForm.propTypes = {
    data: PropTypes.object,
    submitMutation: PropTypes.object.isRequired,
    errorMessage: PropTypes.string.isRequired,
    onSubmitComplete: PropTypes.func,
};

export default DocumentsForm;
